

libname q 'c:\SASCodeforBook\SASDataSets';
Data First; set q.frauddata;

sixoffices = sofice35;
design3 = threclas;
officetypeCFRD = TESPonly;
OfficetypeM2K = V2Konly;
OfficetypeOneSys = OneSys;
OfficetypeBothSys = BothSys;
OfficetypeNoNewSys = ZeroSys;
antiIndex=nwanti3;
run;

data first; set first;

Title 'Model 1, Baseline Model With Office Means Estimated';
Proc Mixed data = first covtest ratio;
class  sixoffices ;
model antiIndex = /s;
random sixoffices / s;
estimate 'random effect office 1-6' |SixOffices 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices 0 0 0 0 0 1;
run;

Title 'Model 2, employee level variables only with office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices;
model AntiIndex = fac1_1 fac2_1 /s;
random SixOffices / s;
estimate 'random effect office 1-6' |SixOffices 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices 0 0 0 0 0 1;
run;


Title 'Model 3a with Nesting, employee level variables + CFRD Only, office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices OfficetypeCFRD;
model AntiIndex = fac1_1 fac2_1 OfficetypeCFRD/s;
random SixOffices(OfficetypeCFRD) / s;
lsmeans OfficetypeCFRD/pdiff adjust=bon;
estimate 'random effect office 1-6' |SixOffices(OfficeTypeCFRD) 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices(OfficeTypeCFRD) 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices(OfficeTypeCFRD) 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices(OfficeTypeCFRD) 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices(OfficeTypeCFRD) 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices(OfficeTypeCFRD) 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices(OfficeTypeCFRD) 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices(OfficeTypeCFRD) 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices(OfficeTypeCFRD) 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices(OfficeTypeCFRD) 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices(OfficeTypeCFRD) 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices(OfficeTypeCFRD) 0 0 0 0 0 1;

run;

Title 'Model 3b with nesting, employee level variables + M2K Only, office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices OfficetypeM2K;
model AntiIndex = fac1_1 fac2_1 OfficetypeM2K/s;
random SixOffices(OfficetypeM2k) / s;
lsmeans OfficetypeM2K/pdiff adjust=bon;
estimate 'random effect office 1-6' |SixOffices(OfficeTypeM2K) 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices(OfficeTypeM2K) 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices(OfficeTypeM2K) 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices(OfficeTypeM2K) 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices(OfficeTypeM2K) 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices(OfficeTypeM2K) 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices(OfficeTypeM2K) 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices(OfficeTypeM2K) 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices(OfficeTypeM2K) 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices(OfficeTypeM2K) 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices(OfficeTypeM2K) 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices(OfficeTypeM2K) 0 0 0 0 0 1;
run;


Title 'Model 3c with nesting,employee level variables + One System Only, office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices OfficetypeOneSys;
model AntiIndex = fac1_1 fac2_1 OfficetypeOneSys/s;
random SixOffices(OfficetypeOneSys) / s;
lsmeans OfficetypeOneSys/pdiff adjust=bon;
estimate 'random effect office 1-6' |SixOffices(OfficeTypeOneSys) 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices(OfficeTypeOneSys) 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices(OfficeTypeOneSys) 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices(OfficeTypeOneSys) 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices(OfficeTypeOneSys) 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices(OfficeTypeOneSys) 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices(OfficeTypeOneSys) 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices(OfficeTypeOneSys) 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices(OfficeTypeOneSys) 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices(OfficeTypeOneSys) 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices(OfficeTypeOneSys) 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices(OfficeTypeOneSys) 0 0 0 0 0 1;
run;

Title 'Model 3d with nesting, employee level variables + Both Systems, office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices OfficetypeBothSys;
model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys/s;
random SixOffices(OfficetypeBothSys) / s;
lsmeans OfficetypeBothSys/pdiff adjust=bon;
estimate 'random effect office 1-6' |SixOffices(OfficeTypeBothSys) 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices(OfficeTypeBothSys) 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices(OfficeTypeBothSys) 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices(OfficeTypeBothSys) 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices(OfficeTypeBothSys) 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices(OfficeTypeBothSys) 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices(OfficeTypeBothSys) 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices(OfficeTypeBothSys) 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices(OfficeTypeBothSys) 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices(OfficeTypeBothSys) 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices(OfficeTypeBothSys) 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices(OfficeTypeBothSys) 0 0 0 0 0 1;
run;

Title 'Model 4, no nesting, employee level variables + Both Systems and One System Indicator
Variables (not class variables), office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices ;
model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys OfficeTypeOneSys/s;
random SixOffices / s;
estimate 'random effect office 1-6' |SixOffices 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices 0 0 0 0 0 1;
run;


Title 'Model 5, no nesting, employee level variables + Both Systems, CFRD, and M2K are Indicator
Variables (not class variables), office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices ;
model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys OfficeTypeCFRD OfficeTypeM2K/s;
random SixOffices / s;
estimate 'random effect office 1-6' |SixOffices 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices 0 0 0 0 0 1;
run;



Title 'Model 5a footnote, no nesting, employee level variables + Both Systems, CFRD, and No New Systems
are indicator variables (not class variables), office means estimated';
Proc Mixed data = first covtest ratio;
class sixoffices ;
model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys OfficeTypeCFRD OfficeTypeNoNewSys/s;
random SixOffices / s;
estimate 'random effect office 1-6' |SixOffices 1 0 0 0 0 0;
estimate 'random effect office 2-6' |SixOffices 0 1 0 0 0 0;
estimate 'random effect office 3-6' |SixOffices 0 0 1 0 0 0;
estimate 'random effect office 4-6' |SixOffices 0 0 0 1 0 0;
estimate 'random effect office 5-6' |SixOffices 0 0 0 0 1 0;
estimate 'random effect office 6-6' |SixOffices 0 0 0 0 0 1;

estimate 'mean office 1-6' intercept 1 |SixOffices 1 0 0 0 0 0;
estimate 'mean office 2-6' intercept 1 |SixOffices 0 1 0 0 0 0;
estimate 'mean office 3-6' intercept 1 |SixOffices 0 0 1 0 0 0;
estimate 'mean office 4-6' intercept 1 |SixOffices 0 0 0 1 0 0;
estimate 'mean office 5-6' intercept 1 |SixOffices 0 0 0 0 1 0;
estimate 'mean office 6-6' intercept 1 |SixOffices 0 0 0 0 0 1;
run;

/*The syntax for Table 9.2 is now complete*/
/*The syntax in this file is copyright by Robert B. Smith,  2011 */

